/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.studi2002.main;

import finanze.IDTE.studi2002.campi.GericoModel;
import finanze.IDTE.studi2002.controlli.GericoControllo;
import finanze.IDTE.studi2002.posizione.Chiave;
import finanze.IDTE.studi2002.posizione.ChiaveStudio;
import java.util.ListResourceBundle;
import java.util.MissingResourceException;
import java.util.Vector;

public class Anomalia {
    public static final ListResourceBundle GRAVITA_ERRORE = new ListResourceBundle(){
        Object[][] contents = new Object[][]{{"scarto", new Integer(16)}, {"scarto_confermabile", new Integer(14)}, {"scarto_confermato", new Integer(8)}, {"anomalia", new Integer(4)}};

        public Object[][] getContents() {
            return this.contents;
        }
    };
    private int gravitaErrore;
    private String tipoErrore;
    private String campoErrato = "";
    private String ch_CodFiscale = "";
    private String ch_CodAttivita = "";
    private String ch_CodStudio = "";
    private String ch_Progressivo = "";
    private String tipoRecord = "";
    private boolean flagNonConforme = false;
    private String ch_Anno = "";
    private String PRE_TIPO_ERRORE = "8";

    public Anomalia(Chiave chiave, String tipoRecord, GericoModel campo) {
        this(campo.getGravitaErrore(), campo.getErrore(), chiave, tipoRecord);
        this.campoErrato = campo.getCode();
    }

    public Anomalia(Chiave chiave, String tipoRecord, GericoControllo controllo) {
        this(controllo.getGravitaErrore(), controllo.getErrore(), chiave, tipoRecord);
        Vector v_campiErrati = controllo.getCampiMsg();
        if (v_campiErrati.size() > 0) {
            String[] campiMsg = null;
            String sepCampi = ",";
            String sepToken = "*";
            StringBuffer campi = new StringBuffer();
            int size_v_campiErrati = v_campiErrati.size();
            int size_campiMsg = 0;
            int i = 0;
            while (i < size_v_campiErrati) {
                campiMsg = (String[])v_campiErrati.elementAt(i);
                size_campiMsg = campiMsg.length;
                int j = 0;
                while (j < size_campiMsg) {
                    campi.append(campiMsg[j]);
                    if (j < size_campiMsg - 1) {
                        campi.append(sepCampi);
                    }
                    ++j;
                }
                if (i < size_v_campiErrati - 1) {
                    campi.append(sepToken);
                }
                ++i;
            }
            this.campoErrato = campi.toString();
        }
    }

    public Anomalia(Chiave chiave, String tipoRecord, String gravitaErrore, String errore) {
        this(gravitaErrore, errore, chiave, tipoRecord);
    }

    public Anomalia(Chiave chiave, String tipoRecord, String gravitaErrore, String errore, String campi) {
        this(gravitaErrore, errore, chiave, tipoRecord);
        this.campoErrato = campi;
    }

    public Anomalia(String codiceGravita, String codiceTipo, Chiave chiave, String tipoRec) {
        this.gravitaErrore = Anomalia.impostaGravitaErrore(codiceGravita);
        if (this.gravitaErrore == -1) {
            throw new IllegalArgumentException("Codice gravita' errore non valido: " + codiceGravita);
        }
        this.tipoErrore = this.getCodiceErrore(codiceTipo);
        if (this.tipoErrore == null) {
            throw new IllegalArgumentException("Codice tipo errore non valido: " + codiceTipo);
        }
        this.impostaTipoRecord(tipoRec, chiave);
    }

    private String getCampoErrato() {
        if (this.campoErrato.length() <= 61) {
            return this.riempiADestra(61, this.campoErrato);
        }
        return this.riempiADestra(61, this.campoErrato.substring(0, 60));
    }

    private String getCodiceErrore(String codice) {
        return String.valueOf(this.PRE_TIPO_ERRORE) + codice;
    }

    private String getCodiceFiscale() {
        if (this.ch_CodFiscale.length() < 16) {
            return this.riempiADestra(16, this.ch_CodFiscale);
        }
        return this.ch_CodFiscale;
    }

    public int getGravitaErrore() {
        return this.gravitaErrore;
    }

    private String getProgressivo() {
        StringBuffer tipoErr = new StringBuffer();
        if (!this.ch_Progressivo.equals("")) {
            try {
                Long.parseLong(this.ch_Progressivo.trim());
                tipoErr.append("YYZ" + this.tipoRecord + this.riempiADestra(5, this.ch_CodStudio) + this.riempiADestra(5, this.ch_CodAttivita) + this.riempiASinistra(2, Long.parseLong(this.ch_Progressivo.trim())));
            }
            catch (NumberFormatException numberFormatException) {
                tipoErr.append("YYZ" + this.tipoRecord + this.riempiADestra(5, this.ch_CodStudio) + this.riempiADestra(5, this.ch_CodAttivita) + this.riempiADestra(2, this.ch_Progressivo));
            }
        } else {
            tipoErr.append("YYZ" + this.tipoRecord + this.riempiADestra(5, this.ch_CodStudio) + this.riempiADestra(5, this.ch_CodAttivita) + this.riempiADestra(2, this.ch_Progressivo));
        }
        return tipoErr.toString();
    }

    public String getRecordDgn(boolean flagBancheEPoste, boolean flagConfermaErrori) {
        StringBuffer sb = new StringBuffer(106);
        if (this.tipoRecord.equals("U") && (this.ch_CodAttivita.equals("52472") || this.ch_CodAttivita.equals("51473") || this.ch_CodAttivita.equals("52471") || this.ch_CodAttivita.equals("5050A") || this.ch_CodAttivita.equals("5050B")) && (this.tipoErrore.equals("8130") || this.tipoErrore.equals("8404"))) {
            sb.append("");
            return sb.toString();
        }
        sb.append("1");
        sb.append(this.getCodiceFiscale());
        if (this.gravitaErrore == 14 && flagConfermaErrori) {
            this.gravitaErrore = 8;
        }
        sb.append(this.riempiASinistra(2, this.gravitaErrore));
        sb.append(this.tipoErrore);
        sb.append(this.getProgressivo());
        sb.append(this.getCampoErrato());
        sb.append(this.riempiASinistra(5, 0L));
        return sb.toString();
    }

    public String getRecordEsi(boolean flagBancheEPoste) {
        StringBuffer sb = new StringBuffer(41);
        if (this.tipoErrore.equals("800") && (this.tipoRecord.equals("S") || this.tipoRecord.equals("T")) && flagBancheEPoste) {
            this.gravitaErrore = 4;
        }
        if (flagBancheEPoste && this.flagNonConforme) {
            this.gravitaErrore = 4;
        }
        if (this.gravitaErrore != 16) {
            return null;
        }
        sb.append(this.riempiASinistra(2, this.gravitaErrore));
        if (this.ch_CodFiscale.length() < 16) {
            sb.append(this.riempiADestra(16, this.ch_CodFiscale));
        } else {
            sb.append(this.ch_CodFiscale);
        }
        sb.append(this.tipoErrore);
        sb.append("YYZ" + this.tipoRecord);
        if (this.campoErrato.length() <= 16) {
            sb.append(this.riempiADestra(16, this.campoErrato));
        } else {
            sb.append(this.riempiADestra(16, this.campoErrato.substring(0, 15)));
        }
        return sb.toString();
    }

    private String getTipoRecord() {
        return this.tipoRecord;
    }

    private static int impostaGravitaErrore(String codice) {
        try {
            return (Integer)GRAVITA_ERRORE.getObject(codice);
        }
        catch (MissingResourceException missingResourceException) {
            return -1;
        }
    }

    private void impostaTipoRecord(String tipoRec, Chiave chiave) {
        this.tipoRecord = tipoRec;
        this.ch_CodFiscale = chiave.getCodiceFiscale();
        if (this.tipoRecord.equals("Q") || this.tipoRecord.equals("R")) {
            this.ch_Anno = String.valueOf(chiave.getAnno());
        } else if (this.tipoRecord.equals("S") || this.tipoRecord.equals("T")) {
            if (!((ChiaveStudio)chiave).getCodiceAttivita().equals("")) {
                this.ch_CodAttivita = ((ChiaveStudio)chiave).getCodiceAttivita();
                this.ch_CodStudio = ((ChiaveStudio)chiave).getCodiceStudio();
            }
            if (!((ChiaveStudio)chiave).getProgressivo().equals("")) {
                this.ch_Progressivo = ((ChiaveStudio)chiave).getProgressivoValido() != null ? ((ChiaveStudio)chiave).getProgressivoValido() : ((ChiaveStudio)chiave).getProgressivo();
            }
        } else if (this.tipoRecord.equals("U") && !((ChiaveStudio)chiave).getCodiceAttivita().equals("")) {
            this.ch_CodAttivita = ((ChiaveStudio)chiave).getCodiceAttivita();
        }
    }

    private String riempiADestra(int lunghezza, String s) {
        StringBuffer sb = new StringBuffer(lunghezza);
        sb.append(s);
        int i = sb.length();
        while (i < lunghezza) {
            sb.append(' ');
            ++i;
        }
        return sb.toString();
    }

    private String riempiASinistra(int lunghezza, long l) {
        String s = String.valueOf(l);
        StringBuffer sb = new StringBuffer(lunghezza);
        int i = s.length();
        while (i < lunghezza) {
            sb.append('0');
            ++i;
        }
        sb.append(s);
        return sb.toString();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[tipo= " + this.tipoErrore + ", gravita= " + this.gravitaErrore + ", campo= " + this.campoErrato + "]";
    }
}

