/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.xades.impl.dom.properties;

import iaik.asn1.structures.Name;
import iaik.utils.RFC2253NameParserException;
import iaik.x509.X509Certificate;
import iaik.xml.crypto.dom.DOMStructure;
import iaik.xml.crypto.dsig.DigestMethodImpl;
import iaik.xml.crypto.utils.DOMUtils;
import iaik.xml.crypto.utils.URI;
import iaik.xml.crypto.utils.URIDereferencerImpl;
import iaik.xml.crypto.utils.URIException;
import iaik.xml.crypto.xades.CertID;
import iaik.xml.crypto.xades.DigestAlgAndValue;
import iaik.xml.crypto.xades.IssuerSerial;
import iaik.xml.crypto.xades.dom.XadesDOMStructure;
import iaik.xml.crypto.xades.impl.dom.properties.CertDigestImpl;
import iaik.xml.crypto.xades.impl.dom.properties.IssuerSerialImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.List;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMURIReference;
import javax.xml.crypto.dsig.XMLSignatureException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class CertIDImpl
extends XadesDOMStructure
implements DOMURIReference,
CertID {
    private byte[] e;
    private InputStream c;
    private IssuerSerialImpl b;
    private CertDigestImpl d;
    private URI a;

    public boolean validate(XMLCryptoContext xMLCryptoContext, Data data) throws XMLSignatureException {
        if (xMLCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null.");
        }
        if (data != null || this.e == null) {
            List list = DOMUtils.distributeNSDeclarations((Element)((Element)this.getNode()));
            if (data == null) {
                data = this.a(xMLCryptoContext);
            }
            if (!(data instanceof OctetStreamData)) {
                throw new XMLSignatureException("Failed to calculate certificate digest. Digest input must be octets.");
            }
            try {
                this.e = this.d.calculateDigestValue(((OctetStreamData)data).getOctetStream(), xMLCryptoContext);
            }
            catch (IOException iOException) {
                throw new XMLSignatureException("Failed to calculate certificate digest.", iOException);
            }
            DOMUtils.withdrawDistributedNSDeclarations((Element)((Element)this.getNode()), (List)list);
        }
        return this.d.getDigestValue() != null ? Arrays.equals(this.d.getDigestValue(), this.e) : false;
    }

    protected void unmarshalAttributes(NamedNodeMap namedNodeMap, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        super.unmarshalAttributes(namedNodeMap, dOMCryptoContext);
        Attr attr = (Attr)namedNodeMap.getNamedItemNS(null, "URI");
        if (attr != null) {
            String string = attr.getValue();
            try {
                this.a = new URI(string);
            }
            catch (URIException uRIException) {
                throw new MarshalException("URI reference '" + string + "' is RFC 2396 complaint. " + uRIException.getMessage());
            }
        }
    }

    protected void putChildStructure(DOMStructure dOMStructure) throws MarshalException {
        super.putChildStructure(dOMStructure);
        if (dOMStructure instanceof CertDigestImpl) {
            this.d = (CertDigestImpl)dOMStructure;
            return;
        }
        if (dOMStructure instanceof IssuerSerialImpl) {
            this.b = (IssuerSerialImpl)dOMStructure;
        }
    }

    protected void marshalAttributes(DOMCryptoContext dOMCryptoContext, Element element) throws MarshalException {
        super.marshalAttributes(dOMCryptoContext, element);
        if (this.a != null) {
            Document document = DOMUtils.getOwnerDocument((Node)element);
            Attr attr = document.createAttributeNS("", "URI");
            attr.setValue(this.a.toString());
            element.setAttributeNodeNS(attr);
        }
    }

    public Node marshal(DOMCryptoContext dOMCryptoContext, Node node, Node node2) throws MarshalException {
        Node node3 = super.marshal(dOMCryptoContext, node, node2);
        if (this.d.getDigestValue() == null) {
            if (this.c == null) {
                throw new MarshalException("Failed to get input for digest calculation.");
            }
            try {
                this.d.calculateAndAppendDigestValue(dOMCryptoContext, this.c);
            }
            catch (XMLSignatureException xMLSignatureException) {
                throw new MarshalException("Failed to calculate certificate digest.", xMLSignatureException);
            }
            catch (IOException iOException) {
                throw new MarshalException("Failed to calculate certificate digest.", iOException);
            }
        }
        return node3;
    }

    public String getURI() {
        String string = null;
        if (this.a != null) {
            string = this.a.toString();
        }
        return string;
    }

    public String getType() {
        return null;
    }

    public String getLocalName() {
        return "Cert";
    }

    public IssuerSerial getIssuerSerial() {
        return this.b;
    }

    public Node getHere() {
        return super.getHere();
    }

    private Data a(XMLCryptoContext xMLCryptoContext) throws XMLSignatureException {
        URIDereferencer uRIDereferencer;
        URIDereferencer uRIDereferencer2 = uRIDereferencer = xMLCryptoContext.getURIDereferencer() != null ? xMLCryptoContext.getURIDereferencer() : new URIDereferencerImpl();
        if (uRIDereferencer == null) {
            throw new XMLSignatureException("No URIDereferencer set in provider");
        }
        try {
            return uRIDereferencer.dereference(this, xMLCryptoContext);
        }
        catch (URIReferenceException uRIReferenceException) {
            throw new XMLSignatureException("Failed to dereference URI '" + this.getURI() + "'. ", uRIReferenceException);
        }
    }

    protected List getChildStructures() {
        List list = super.getChildStructures();
        if (this.d != null) {
            list.add(this.d);
        }
        if (this.b != null) {
            list.add(this.b);
        }
        return list;
    }

    public DigestAlgAndValue getCertDigest() {
        return this.d;
    }

    public CertIDImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null");
        }
        this.unmarshal(dOMCryptoContext);
        if (this.d == null || this.b == null) {
            throw new MarshalException("The content of element '" + node + "' is not complete.");
        }
    }

    public CertIDImpl(String string, java.security.cert.X509Certificate x509Certificate, DigestMethodImpl digestMethodImpl) {
        this(string);
        String string2;
        X509Certificate x509Certificate2;
        if (x509Certificate == null) {
            throw new NullPointerException("Argument 'certificate' must not be null.");
        }
        if (x509Certificate instanceof X509Certificate) {
            x509Certificate2 = (X509Certificate)x509Certificate;
        } else {
            try {
                x509Certificate2 = new X509Certificate(x509Certificate.getEncoded());
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IllegalArgumentException("Failed to encode given X509 certificate. " + certificateEncodingException.getMessage());
            }
            catch (CertificateException certificateException) {
                throw new IllegalArgumentException("Failed to decode given X509 certificate. " + certificateException.getMessage());
            }
        }
        try {
            string2 = ((Name)x509Certificate2.getIssuerDN()).getRFC2253String();
        }
        catch (RFC2253NameParserException rFC2253NameParserException) {
            throw new IllegalArgumentException("Failed to encode IssuerName according to RFC 2253. " + rFC2253NameParserException.getMessage());
        }
        BigInteger bigInteger = x509Certificate.getSerialNumber();
        this.b = new IssuerSerialImpl(string2, bigInteger);
        try {
            this.c = new ByteArrayInputStream(x509Certificate.getEncoded());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new IllegalArgumentException("Failed to encode given X509 certificate, " + certificateEncodingException.getMessage());
        }
        this.d = new CertDigestImpl(digestMethodImpl);
    }

    public CertIDImpl(String string, IssuerSerialImpl issuerSerialImpl, DigestMethodImpl digestMethodImpl, InputStream inputStream) {
        this(string);
        if (issuerSerialImpl == null) {
            throw new NullPointerException("Argument 'issuerSerial' must not be null.");
        }
        this.b = issuerSerialImpl;
        if (digestMethodImpl == null) {
            throw new NullPointerException("Argument 'digestMethod' must not be null.");
        }
        this.d = new CertDigestImpl(digestMethodImpl);
        if (inputStream == null) {
            throw new NullPointerException("Argument 'digestInput' must not be null.");
        }
        this.c = inputStream;
    }

    public CertIDImpl(String string, DigestMethodImpl digestMethodImpl, byte[] byArray, IssuerSerialImpl issuerSerialImpl) {
        this(string);
        if (digestMethodImpl == null) {
            throw new NullPointerException("Argument 'digestMethod' must not be null.");
        }
        if (byArray == null) {
            throw new NullPointerException("Argument 'digestValue' must not be null.");
        }
        this.d = new CertDigestImpl(digestMethodImpl, byArray);
        if (issuerSerialImpl == null) {
            throw new NullPointerException("Argument 'issuerSerial' must not be null.");
        }
        this.b = issuerSerialImpl;
    }

    private CertIDImpl(String string) {
        if (string != null) {
            try {
                this.a = new URI(string);
            }
            catch (URIException uRIException) {
                throw new IllegalArgumentException("Argument 'uri' is not RFC 2396 complaint. " + uRIException.getMessage());
            }
        }
    }
}

