/*
 * Decompiled with CFR 0.152.
 */
package demo.smime;

import demo.DemoUtil;
import demo.keystore.CMSKeyStore;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Name;
import iaik.pkcs.PKCSException;
import iaik.pkcs.pkcs10.CertificateRequest;
import iaik.smime.CryptoContent;
import iaik.smime.EncryptedContent;
import iaik.smime.PKCS10Content;
import iaik.smime.SMimeBodyPart;
import iaik.smime.SMimeMultipart;
import iaik.smime.SMimeParameters;
import iaik.smime.SignedContent;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.Date;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class SMimeSend {
    PrivateKey signerPrivateKey;
    X509Certificate encryptionCertOfSigner;
    X509Certificate signerCertificate;
    X509Certificate recipientCertificate;
    X509Certificate[] signerCertificates;
    String host = "mailhost";
    String from = "smimetest@iaik.at";
    String to = "smimetest@iaik.at";
    String lastName = "SMime";
    String firstName = "John";

    public void start() throws IOException {
        Session session = DemoUtil.getSession();
        try {
            SMimeBodyPart sMimeBodyPart = new SMimeBodyPart();
            sMimeBodyPart.setText("This is a Test of the IAIK S/MIME implementation!\n\n");
            SMimeBodyPart sMimeBodyPart2 = new SMimeBodyPart();
            sMimeBodyPart2.setDataHandler(new DataHandler((DataSource)new FileDataSource("test.html")));
            sMimeBodyPart2.setFileName("test.html");
            SMimeMultipart sMimeMultipart = new SMimeMultipart();
            sMimeMultipart.addBodyPart((BodyPart)sMimeBodyPart);
            sMimeMultipart.addBodyPart((BodyPart)sMimeBodyPart2);
            DataHandler dataHandler = new DataHandler((Object)sMimeMultipart, sMimeMultipart.getContentType());
            Message message = this.createPlainMessage(session, dataHandler);
            System.out.println("sending plain message...");
            Transport.send((Message)message);
            message = this.createSignedMessage(session, dataHandler, false);
            System.out.println("sending explicitly signed message...");
            Transport.send((Message)message);
            message = this.createSignedMessage(session, dataHandler, true);
            System.out.println("sending implicitly signed message...");
            Transport.send((Message)message);
            message = this.createEncryptedMessage(session, (AlgorithmID)AlgorithmID.rc2_CBC.clone(), 40);
            System.out.println("sending encrypted message [RC2/40]...");
            Transport.send((Message)message);
            message = this.createEncryptedMessage(session, (AlgorithmID)AlgorithmID.rc2_CBC.clone(), 64);
            System.out.println("sending encrypted message [RC2/64]...");
            Transport.send((Message)message);
            message = this.createEncryptedMessage(session, (AlgorithmID)AlgorithmID.rc2_CBC.clone(), 128);
            System.out.println("sending encrypted message [RC2/128]...");
            Transport.send((Message)message);
            message = this.createEncryptedMessage(session, (AlgorithmID)AlgorithmID.des_EDE3_CBC.clone(), 192);
            System.out.println("sending encrypted message [TripleDES]...");
            Transport.send((Message)message);
            message = this.createSignedAndEncryptedMessage(session, dataHandler, true);
            System.out.println("sending implicitly signed and encrypted message [RC2/40]...");
            Transport.send((Message)message);
            message = this.createSignedAndEncryptedMessage(session, dataHandler, false);
            System.out.println("sending explicitly signed and encrypted message [RC2/40]...");
            Transport.send((Message)message);
            message = this.createCertsOnlyMessage(session);
            System.out.println("sending certs-only message");
            Transport.send((Message)message);
            message = this.createCertsOnlyMultiPartMessage(session);
            System.out.println("sending message with certs-only part");
            Transport.send((Message)message);
            message = this.createPKCS10Message(session);
            System.out.println("sending application/pkcs10 message...");
            Transport.send((Message)message);
            message = this.createPKCS10MultiPartMessage(session);
            System.out.println("sending message with pkcs10 part...");
            Transport.send((Message)message);
        }
        catch (MessagingException messagingException) {
            messagingException.printStackTrace();
            Exception exception = null;
            exception = messagingException.getNextException();
            if (exception != null) {
                exception.printStackTrace();
            }
            throw new RuntimeException();
        }
        System.out.println("OK!");
        System.in.read();
    }

    public static void main(String[] stringArray) throws IOException {
        DemoUtil.initSMimeDemos();
        new SMimeSend().start();
        Util.waitKey();
        System.exit(0);
    }

    public Message createSignedMessage(Session session, DataHandler dataHandler, boolean bl) throws MessagingException {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            string = "IAIK-S/MIME: Implicitly Signed";
            stringBuffer.append("This message is implicitly signed!\n");
            stringBuffer.append("You need an S/MIME aware mail client to view this message.\n");
            stringBuffer.append("\n\n");
        } else {
            string = "IAIK-S/MIME: Explicitly Signed";
            stringBuffer.append("This message is explicitly signed!\n");
            stringBuffer.append("Every mail client can view this message.\n");
            stringBuffer.append("Non S/MIME mail clients will show the signature as attachment.\n");
            stringBuffer.append("\n\n");
        }
        Message message = this.createMessage(session, string);
        SignedContent signedContent = new SignedContent(bl);
        if (dataHandler != null) {
            signedContent.setDataHandler(dataHandler);
        } else {
            signedContent.setText(stringBuffer.toString());
        }
        signedContent.setCertificates((Certificate[])this.signerCertificates);
        try {
            signedContent.addSigner((PrivateKey)((RSAPrivateKey)this.signerPrivateKey), this.signerCertificate, this.encryptionCertOfSigner, true);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new MessagingException("Algorithm not supported: " + noSuchAlgorithmException.getMessage(), (Exception)noSuchAlgorithmException);
        }
        message.setContent((Object)signedContent, signedContent.getContentType());
        signedContent.setHeaders((Part)message);
        return message;
    }

    public Message createSignedAndEncryptedMessage(Session session, DataHandler dataHandler, boolean bl) throws MessagingException {
        String string = null;
        String string2 = null;
        if (bl) {
            string = "IAIK-S/MIME: Implicitly Signed and Encrypted";
            string2 = "This message is implicitly signed and encrypted!\n\n\n";
        } else {
            string = "IAIK-S/MIME: Explicitly Signed and Encrypted";
            string2 = "This message is explicitly signed and encrypted!\n\n\n";
        }
        Message message = this.createMessage(session, string);
        SignedContent signedContent = new SignedContent(bl);
        if (dataHandler != null) {
            signedContent.setDataHandler(dataHandler);
        } else {
            signedContent.setText(string2);
        }
        signedContent.setCertificates((Certificate[])this.signerCertificates);
        try {
            signedContent.addSigner((PrivateKey)((RSAPrivateKey)this.signerPrivateKey), this.signerCertificate, this.encryptionCertOfSigner, true);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new MessagingException("Algorithm not supported: " + noSuchAlgorithmException.getMessage(), (Exception)noSuchAlgorithmException);
        }
        EncryptedContent encryptedContent = new EncryptedContent((CryptoContent)signedContent);
        encryptedContent.addRecipient(this.recipientCertificate, AlgorithmID.rsaEncryption);
        encryptedContent.addRecipient(this.encryptionCertOfSigner, AlgorithmID.rsaEncryption);
        try {
            encryptedContent.setEncryptionAlgorithm((AlgorithmID)AlgorithmID.rc2_CBC.clone(), 40);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new MessagingException("Content encryption algorithm not supported: " + noSuchAlgorithmException.getMessage());
        }
        message.setContent((Object)encryptedContent, encryptedContent.getContentType());
        encryptedContent.setHeaders((Part)message);
        return message;
    }

    public Message createPlainMessage(Session session, DataHandler dataHandler) throws MessagingException {
        Message message = this.createMessage(session, "IAIK-S/MIME: Plain message");
        if (dataHandler != null) {
            message.setDataHandler(dataHandler);
        } else {
            message.setText("This is a plain message!\nIt is wether signed nor encrypted!\n");
        }
        return message;
    }

    public Message createPKCS10MultiPartMessage(Session session) throws MessagingException {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setText("This is a test where the request message is included in the second part!\n\n");
        MimeBodyPart mimeBodyPart2 = new MimeBodyPart();
        SMimeParameters.useNewContentTypes((boolean)true);
        PKCS10Content pKCS10Content = new PKCS10Content();
        CertificateRequest certificateRequest = null;
        try {
            certificateRequest = this.a();
        }
        catch (PKCSException pKCSException) {
            throw new MessagingException(pKCSException.getMessage());
        }
        pKCS10Content.setCertRequest(certificateRequest);
        DataHandler dataHandler = new DataHandler((Object)pKCS10Content, pKCS10Content.getContentType());
        mimeBodyPart2.setDataHandler(dataHandler);
        mimeBodyPart2.setDisposition("attachment");
        mimeBodyPart2.setFileName("smime.p10");
        MimeMultipart mimeMultipart = new MimeMultipart();
        mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
        mimeMultipart.addBodyPart((BodyPart)mimeBodyPart2);
        Message message = this.createMessage(session, "IAIK-S/MIME: Certificate Request multipart message");
        message.setContent((Object)mimeMultipart, mimeMultipart.getContentType());
        return message;
    }

    public Message createPKCS10Message(Session session) throws MessagingException {
        Message message = this.createMessage(session, "IAIK-S/MIME: Certificate Request");
        PKCS10Content pKCS10Content = new PKCS10Content();
        CertificateRequest certificateRequest = null;
        try {
            certificateRequest = this.a();
        }
        catch (PKCSException pKCSException) {
            throw new MessagingException(pKCSException.getMessage());
        }
        pKCS10Content.setCertRequest(certificateRequest);
        message.setContent((Object)pKCS10Content, pKCS10Content.getContentType());
        pKCS10Content.setHeaders((Part)message);
        return message;
    }

    public Message createMessage(Session session, String string) throws MessagingException {
        MimeMessage mimeMessage = new MimeMessage(session);
        mimeMessage.setFrom((Address)new InternetAddress(this.from));
        mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this.to, (boolean)false));
        mimeMessage.setSentDate(new Date());
        mimeMessage.setSubject(string);
        return mimeMessage;
    }

    public Message createEncryptedMessage(Session session, AlgorithmID algorithmID, int n) throws MessagingException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IAIK-S/MIME: Encrypted [" + algorithmID.getName());
        if (n > 0) {
            stringBuffer.append("/" + n);
        }
        stringBuffer.append("]");
        Message message = this.createMessage(session, stringBuffer.toString());
        EncryptedContent encryptedContent = new EncryptedContent();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("This is the encrypted content!\n");
        stringBuffer2.append("Content encryption algorithm: " + algorithmID.getName());
        stringBuffer2.append("\n\n");
        encryptedContent.setText(stringBuffer2.toString());
        encryptedContent.addRecipient(this.recipientCertificate, AlgorithmID.rsaEncryption);
        encryptedContent.addRecipient(this.encryptionCertOfSigner, AlgorithmID.rsaEncryption);
        try {
            encryptedContent.setEncryptionAlgorithm(algorithmID, n);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new MessagingException("Content encryption algorithm not supported: " + noSuchAlgorithmException.getMessage());
        }
        message.setContent((Object)encryptedContent, encryptedContent.getContentType());
        encryptedContent.setHeaders((Part)message);
        return message;
    }

    public Message createCertsOnlyMultiPartMessage(Session session) throws MessagingException {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setText("This is a test where the certs-only message is included in the second part!\n\n");
        MimeBodyPart mimeBodyPart2 = new MimeBodyPart();
        SMimeParameters.useNewContentTypes((boolean)true);
        SignedContent signedContent = new SignedContent(true, "certs-only");
        signedContent.setCertificates((Certificate[])this.signerCertificates);
        mimeBodyPart2.setContent((Object)signedContent, signedContent.getContentType());
        signedContent.setHeaders((Part)mimeBodyPart2);
        MimeMultipart mimeMultipart = new MimeMultipart();
        mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
        mimeMultipart.addBodyPart((BodyPart)mimeBodyPart2);
        Message message = this.createMessage(session, "IAIK S/MIME: Certs-only multipart message");
        message.setContent((Object)mimeMultipart, mimeMultipart.getContentType());
        return message;
    }

    public Message createCertsOnlyMessage(Session session) throws MessagingException {
        Message message = this.createMessage(session, "IAIK S/MIME: Certs-only message");
        SMimeParameters.useNewContentTypes((boolean)true);
        SignedContent signedContent = new SignedContent(true, "certs-only");
        signedContent.setCertificates((Certificate[])this.signerCertificates);
        message.setContent((Object)signedContent, signedContent.getContentType());
        signedContent.setHeaders((Part)message);
        return message;
    }

    private CertificateRequest a() throws PKCSException {
        try {
            Name name = new Name();
            name.addRDN(ObjectID.commonName, (Object)(String.valueOf(this.firstName) + " " + this.lastName));
            name.addRDN(ObjectID.emailAddress, (Object)this.from);
            CertificateRequest certificateRequest = new CertificateRequest(this.signerCertificate.getPublicKey(), name);
            certificateRequest.sign(AlgorithmID.sha1WithRSAEncryption, this.signerPrivateKey);
            certificateRequest.verify();
            return certificateRequest;
        }
        catch (Exception exception) {
            throw new PKCSException("Cannot create cert request: " + exception.getMessage());
        }
    }

    public SMimeSend() {
        System.out.println();
        System.out.println("******************************************************************************************");
        System.out.println("*                                 SMimeSend demo                                         *");
        System.out.println("*         (shows how to create and send signed and encrypted S/MIME messages)            *");
        System.out.println("******************************************************************************************");
        System.out.println();
        this.signerCertificates = CMSKeyStore.getCertificateChain(0, 1);
        this.signerPrivateKey = CMSKeyStore.getPrivateKey(0, 1);
        this.signerCertificate = this.signerCertificates[0];
        this.recipientCertificate = CMSKeyStore.getCertificateChain(0, 5)[0];
        this.encryptionCertOfSigner = CMSKeyStore.getCertificateChain(0, 5)[0];
        X509Certificate[] x509CertificateArray = new X509Certificate[this.signerCertificates.length + 1];
        System.arraycopy(this.signerCertificates, 0, x509CertificateArray, 0, this.signerCertificates.length);
        x509CertificateArray[this.signerCertificates.length] = this.encryptionCertOfSigner;
        this.signerCertificates = x509CertificateArray;
    }
}

