/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.dsig.spec;

import iaik.xml.crypto.dsig.spec.AlgorithmParameterImpl;
import iaik.xml.crypto.utils.DOMUtils;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HMACParameterImpl
extends AlgorithmParameterImpl {
    protected Integer outputLength_;

    protected void unmarshalElement(DOMCryptoContext dOMCryptoContext, Element element) throws MarshalException {
        super.unmarshalElement(dOMCryptoContext, element);
        String string = DOMUtils.getAllTextFromChildren(element);
        try {
            this.outputLength_ = new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new MarshalException("Failed to parse HMACOutputLength value '" + string + "'.", numberFormatException);
        }
    }

    protected Element marshalElement(DOMCryptoContext dOMCryptoContext, Node node, Node node2) throws MarshalException {
        Element element = super.marshalElement(dOMCryptoContext, node, node2);
        DOMUtils.addTextToElement(element, this.outputLength_.toString());
        return element;
    }

    public int getOutputLength() {
        return this.outputLength_;
    }

    public String getNamespace() {
        return "http://www.w3.org/2000/09/xmldsig#";
    }

    public String getLocalName() {
        return "HMACOutputLength";
    }

    public HMACParameterImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null");
        }
        this.unmarshal(dOMCryptoContext);
        if (this.outputLength_ == null) {
            throw new MarshalException("The content of element '" + node + "' is not complete.");
        }
    }

    public HMACParameterImpl(int n) {
        this.outputLength_ = new Integer(n);
    }
}

