/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.enc;

import iaik.xml.crypto.dom.DOMStructure;
import iaik.xml.crypto.dsig.ReferenceType;
import iaik.xml.crypto.enc.TransformsImpl;
import iaik.xml.crypto.utils.DOMUtils;
import iaik.xml.crypto.utils.URI;
import iaik.xml.crypto.utils.URIException;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMURIReference;
import javax.xml.crypto.enc.CipherReference;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class CipherReferenceImpl
extends ReferenceType
implements DOMURIReference,
CipherReference {
    protected void unmarshalAttributes(NamedNodeMap namedNodeMap, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        super.unmarshalAttributes(namedNodeMap, dOMCryptoContext);
        Attr attr = (Attr)namedNodeMap.getNamedItemNS(null, "URI");
        if (attr != null) {
            String string = attr.getValue();
            try {
                this.uri_ = new URI(string);
            }
            catch (URIException uRIException) {
                throw new MarshalException("The URI '" + string + "' is not RFC 2396 compliant. " + uRIException.getMessage());
            }
        }
    }

    protected void putChildStructure(DOMStructure dOMStructure) throws MarshalException {
        super.putChildStructure(dOMStructure);
        if (dOMStructure instanceof TransformsImpl) {
            this.transforms_ = (TransformsImpl)dOMStructure;
        }
    }

    protected void marshalAttributes(DOMCryptoContext dOMCryptoContext, Element element) throws MarshalException {
        super.marshalAttributes(dOMCryptoContext, element);
        Document document = DOMUtils.getOwnerDocument(element);
        if (this.uri_ != null) {
            Attr attr = document.createAttributeNS("", "URI");
            attr.setValue(this.uri_.toString());
            element.setAttributeNodeNS(attr);
        }
    }

    public String getURI() {
        return this.uri_.toString();
    }

    public String getType() {
        return this.type_;
    }

    public List getTransforms() {
        return this.transforms_ != null ? this.transforms_.getTransforms() : Collections.EMPTY_LIST;
    }

    public String getNamespace() {
        return "http://www.w3.org/2001/04/xmlenc#";
    }

    public String getLocalName() {
        return "CipherReference";
    }

    public CipherReferenceImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null.");
        }
        this.unmarshal(dOMCryptoContext);
        if (this.uri_ == null) {
            throw new MarshalException("The content of element '" + node + "' is not complete.");
        }
    }

    public CipherReferenceImpl(String string, List list, String string2, String string3) {
        super(string, string2);
        if (list != null && !list.isEmpty()) {
            this.transforms_ = new TransformsImpl(list);
        }
        this.id_ = string3;
    }

    public CipherReferenceImpl(String string, List list) {
        this(string, list, null, null);
        if (string == null) {
            throw new NullPointerException("The argument 'uri' must not be null.");
        }
    }
}

