/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public abstract class Nodes {
    public static Iterator EMPTY_ITERATOR;
    public static NodeList EMPTY_NODE_LIST;
    public static NodeIterator EMPTY_NODE_ITERATOR;

    public static NodeList singletonNodeList(Node node) {
        return new SingletonNodeList(node);
    }

    public static NodeIterator singletonNodeIterator(Node node) {
        return new SingletonNodeIterator(node);
    }

    public static Iterator singletonIterator(Object object) {
        return new SingletonIterator(object);
    }

    public static NodeList nodeList(NodeIterator nodeIterator) {
        Node node;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        while ((node = nodeIterator.nextNode()) != null) {
            arrayList.add(node);
        }
        return Nodes.nodeList(arrayList);
    }

    public static NodeList nodeList(List list) {
        return new ListNodeList(list);
    }

    public static NodeList nodeList(Iterator iterator) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            arrayList.add(node);
        }
        return Nodes.nodeList(arrayList);
    }

    public static NodeIterator nodeIterator(NodeList nodeList) {
        return new NodeListNodeIterator(nodeList);
    }

    public static NodeIterator nodeIterator(List list) {
        return Nodes.nodeIterator(Nodes.nodeList(list));
    }

    public static Iterator iterator(NodeIterator nodeIterator) {
        if (nodeIterator == null) {
            throw new NullPointerException("Argument 'ni' can not be null.");
        }
        return new NodeIteratorIterator(nodeIterator);
    }

    public static Iterator iterator(NodeList nodeList) {
        if (nodeList == null) {
            throw new NullPointerException("Argument 'nl' can not be null.");
        }
        return new NodeListIterator(nodeList);
    }

    static {
        EMPTY_NODE_ITERATOR = new EmptyNodeIterator();
        EMPTY_NODE_LIST = new EmptyNodeList();
        EMPTY_ITERATOR = new EmptyIterator();
    }

    private static class NodeListNodeIterator
    implements NodeIterator {
        protected int curPosition;
        protected NodeList nodeList_;
        protected boolean valid_ = true;

        public Node previousNode() throws DOMException {
            if (this.valid_ && this.nodeList_ != null) {
                if (this.curPosition > 0) {
                    return this.nodeList_.item(--this.curPosition);
                }
                return null;
            }
            throw new DOMException(11, "INVALID_STATE_ERR");
        }

        public Node nextNode() throws DOMException {
            if (this.valid_ && this.nodeList_ != null) {
                if (this.curPosition < this.nodeList_.getLength()) {
                    return this.nodeList_.item(this.curPosition++);
                }
                return null;
            }
            throw new DOMException(11, "INVALID_STATE_ERR");
        }

        public int getWhatToShow() {
            return -1;
        }

        public Node getRoot() {
            if (this.valid_ && this.nodeList_ != null) {
                return this.nodeList_.item(0);
            }
            throw new DOMException(11, "INVALID_STATE_ERR");
        }

        public NodeFilter getFilter() {
            return null;
        }

        public boolean getExpandEntityReferences() {
            return false;
        }

        public void detach() {
            this.valid_ = false;
        }

        public NodeListNodeIterator(NodeList nodeList) {
            this.nodeList_ = nodeList;
        }
    }

    private static class SingletonNodeIterator
    implements NodeIterator {
        protected Node node_;
        protected int cursor_ = 0;

        public Node previousNode() throws DOMException {
            switch (this.cursor_) {
                case 0: {
                    --this.cursor_;
                    return this.node_;
                }
                case 1: {
                    --this.cursor_;
                    return null;
                }
            }
            return null;
        }

        public Node nextNode() throws DOMException {
            switch (this.cursor_) {
                case -1: {
                    ++this.cursor_;
                    return null;
                }
                case 0: {
                    ++this.cursor_;
                    return this.node_;
                }
            }
            return null;
        }

        public int getWhatToShow() {
            return -1;
        }

        public Node getRoot() {
            return this.node_;
        }

        public NodeFilter getFilter() {
            return null;
        }

        public boolean getExpandEntityReferences() {
            return false;
        }

        public void detach() {
        }

        public SingletonNodeIterator(Node node) {
            this.node_ = node;
        }
    }

    private static class EmptyNodeIterator
    implements NodeIterator {
        public Node previousNode() throws DOMException {
            return null;
        }

        public Node nextNode() throws DOMException {
            return null;
        }

        public int getWhatToShow() {
            return -1;
        }

        public Node getRoot() {
            return null;
        }

        public NodeFilter getFilter() {
            return null;
        }

        public boolean getExpandEntityReferences() {
            return false;
        }

        public void detach() {
        }

        EmptyNodeIterator() {
        }
    }

    private static class EmptyNodeList
    implements NodeList {
        public Node item(int n) {
            return null;
        }

        public int getLength() {
            return 0;
        }

        EmptyNodeList() {
        }
    }

    private static class EmptyIterator
    implements Iterator {
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public boolean hasNext() {
            return false;
        }

        EmptyIterator() {
        }
    }

    private static class SingletonIterator
    implements Iterator {
        private Object object_;

        public void remove() {
            this.object_ = null;
        }

        public Object next() {
            Object object = this.object_;
            this.remove();
            return object;
        }

        public boolean hasNext() {
            return this.object_ != null;
        }

        protected SingletonIterator(Object object) {
            this.object_ = object;
        }
    }

    private static class SingletonNodeList
    implements NodeList {
        protected Node node_;

        public Node item(int n) {
            return n == 0 ? this.node_ : null;
        }

        public int getLength() {
            return 1;
        }

        public SingletonNodeList(Node node) {
            this.node_ = node;
        }
    }

    private static class ListNodeList
    implements NodeList {
        protected List nodes_;

        public Node item(int n) {
            if (n < 0 || n >= this.nodes_.size()) {
                return null;
            }
            return (Node)this.nodes_.get(n);
        }

        public int getLength() {
            return this.nodes_.size();
        }

        public ListNodeList(List list) {
            this.nodes_ = list;
        }
    }

    private static class NodeListIterator
    implements Iterator {
        protected int cursor_;
        protected NodeList nl_;

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Object next() {
            if (this.cursor_ < this.nl_.getLength()) {
                return this.nl_.item(this.cursor_++);
            }
            throw new NoSuchElementException();
        }

        public boolean hasNext() {
            return this.cursor_ < this.nl_.getLength();
        }

        public NodeListIterator(NodeList nodeList) {
            this.nl_ = nodeList;
            this.cursor_ = 0;
        }
    }

    private static class NodeIteratorIterator
    implements Iterator {
        protected boolean isInitialized_ = false;
        protected Node next_;
        protected NodeIterator ni_;

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Object next() {
            if (this.hasNext()) {
                Node node = this.next_;
                this.next_ = this.ni_.nextNode();
                return node;
            }
            throw new NoSuchElementException();
        }

        public boolean hasNext() {
            if (!this.isInitialized_) {
                this.next_ = this.ni_.nextNode();
                this.isInitialized_ = true;
            }
            return this.next_ != null;
        }

        public NodeIteratorIterator(NodeIterator nodeIterator) {
            this.ni_ = nodeIterator;
        }
    }
}

