/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.enc;

import iaik.xsect.com.fourthpass.a;
import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.NoSuchMechanismException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.enc.CipherReference;
import javax.xml.crypto.enc.DataReference;
import javax.xml.crypto.enc.EncryptedData;
import javax.xml.crypto.enc.EncryptedType;
import javax.xml.crypto.enc.EncryptionMethod;
import javax.xml.crypto.enc.EncryptionProperties;
import javax.xml.crypto.enc.EncryptionProperty;
import javax.xml.crypto.enc.KeyReference;
import javax.xml.crypto.enc.ToBeEncrypted;
import javax.xml.crypto.enc.ToBeEncryptedKey;
import javax.xml.crypto.enc.XMLDecryptContext;
import javax.xml.crypto.enc.XMLEncryptionException;
import javax.xml.crypto.enc.keyinfo.AgreementMethod;
import javax.xml.crypto.enc.keyinfo.EncryptedKey;
import javax.xml.crypto.enc.spec.AgreementMethodParameterSpec;
import javax.xml.crypto.enc.spec.EncryptionMethodParameterSpec;

public abstract class XMLEncryptionFactory {
    private Provider provider;
    private String mechanismType;
    private static final String TYPE = "XMLEncryptionFactory";

    public abstract EncryptedType unmarshalEncryptedType(XMLDecryptContext var1) throws MarshalException;

    public abstract KeyReference newKeyReference(String var1, List var2);

    public abstract EncryptionProperty newEncryptionProperty(List var1, String var2, String var3, Map var4);

    public abstract EncryptionProperties newEncryptionProperties(List var1, String var2);

    public abstract EncryptionMethod newEncryptionMethod(String var1, Integer var2, EncryptionMethodParameterSpec var3) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException;

    public abstract EncryptedKey newEncryptedKey(ToBeEncryptedKey var1, EncryptionMethod var2, KeyInfo var3, EncryptionProperties var4, List var5, String var6, String var7, String var8, CipherReference var9);

    public abstract EncryptedKey newEncryptedKey(ToBeEncryptedKey var1, EncryptionMethod var2, KeyInfo var3, EncryptionProperties var4, List var5, String var6, String var7, String var8);

    public abstract EncryptedData newEncryptedData(ToBeEncrypted var1, EncryptionMethod var2, KeyInfo var3, EncryptionProperties var4, String var5, CipherReference var6);

    public abstract EncryptedData newEncryptedData(ToBeEncrypted var1, EncryptionMethod var2, KeyInfo var3, EncryptionProperties var4, String var5);

    public abstract DataReference newDataReference(String var1, List var2);

    public abstract CipherReference newCipherReference(String var1, List var2);

    public abstract CanonicalizationMethod newCanonicalizationMethod(String var1, C14NMethodParameterSpec var2) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException;

    public abstract AgreementMethod newAgreementMethod(String var1, byte[] var2, XMLStructure var3, XMLStructure var4, AgreementMethodParameterSpec var5) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException;

    public abstract boolean isFeatureSupported(String var1);

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getMechanismType() {
        return this.mechanismType;
    }

    public static XMLEncryptionFactory getInstance(String string, Provider provider) throws NoSuchMechanismException {
        if (string == null) {
            throw new NullPointerException("mechanismType cannot be null");
        }
        if (provider == null) {
            throw new NullPointerException("provider cannot be null");
        }
        try {
            return XMLEncryptionFactory.findInstance(string, provider);
        }
        catch (XMLEncryptionException xMLEncryptionException) {
            throw new NoSuchMechanismException("Cannot find " + string + " mechanism type.", xMLEncryptionException);
        }
    }

    public static XMLEncryptionFactory getInstance(String string, String string2) throws NoSuchProviderException, NoSuchMechanismException {
        if (string == null) {
            throw new NullPointerException("mechanismType cannot be null");
        }
        if (string2 == null) {
            throw new NullPointerException("provider cannot be null");
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException("cannot find provider named " + string2);
        }
        try {
            return XMLEncryptionFactory.findInstance(string, provider);
        }
        catch (XMLEncryptionException xMLEncryptionException) {
            throw new NoSuchMechanismException("Cannot find " + string + " mechanism type.", xMLEncryptionException);
        }
    }

    public static XMLEncryptionFactory getInstance(String string) throws NoSuchMechanismException {
        if (string == null) {
            throw new NullPointerException("mechanismType cannot be null");
        }
        try {
            return XMLEncryptionFactory.findInstance(string, null);
        }
        catch (XMLEncryptionException xMLEncryptionException) {
            throw new NoSuchMechanismException("Cannot find " + string + " mechanism type.", xMLEncryptionException);
        }
    }

    public static XMLEncryptionFactory getInstance() throws NoSuchMechanismException {
        try {
            Class<?> clazz = Class.forName("iaik.xml.crypto.enc.XMLEncryptionFactory");
            return (XMLEncryptionFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("could not find implementation of XMLEncryptionFactory");
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException("Error when instantiating XMLEncryptionFactory");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Error when instantiating XMLEncryptionFactory");
        }
    }

    private static XMLEncryptionFactory findInstance(String string, Provider serializable) throws XMLEncryptionException {
        Object object;
        Object object2;
        Serializable serializable2;
        Provider[] providerArray;
        String string2 = null;
        if (serializable != null) {
            Provider[] providerArray2 = new Provider[1];
            providerArray = providerArray2;
            providerArray2[0] = serializable;
        } else {
            providerArray = Security.getProviders();
        }
        Provider[] providerArray3 = providerArray;
        int n = 0;
        while (n < providerArray3.length) {
            serializable2 = providerArray3[n];
            object2 = ((Properties)serializable2).getProperty("Alg.Alias.XMLEncryptionFactory." + string);
            object = "XMLEncryptionFactory." + (String)(object2 != null ? object2 : string);
            String string3 = ((Properties)serializable2).getProperty((String)object);
            if (string3 != null) {
                string2 = string3;
                serializable = serializable2;
                break;
            }
            ++n;
        }
        if (string2 == null) {
            throw new NoSuchMechanismException("Cannot find " + string + " mechanism type.");
        }
        try {
            object2 = serializable.getClass().getClassLoader();
            serializable2 = object2 != null ? ((ClassLoader)object2).loadClass(string2) : a.a(string2);
            object = (XMLEncryptionFactory)((Class)serializable2).newInstance();
            ((XMLEncryptionFactory)object).mechanismType = string;
            ((XMLEncryptionFactory)object).provider = serializable;
            return object;
        }
        catch (ClassCastException classCastException) {
            throw new XMLEncryptionException("Class '" + string2 + "' configured for " + TYPE + " " + "(provider: " + serializable.getName() + ")" + " is not a " + TYPE + ".", classCastException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new XMLEncryptionException("Class '" + string2 + "' configured for " + TYPE + " " + "(provider: " + serializable.getName() + ")" + " cannot be found.", classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new XMLEncryptionException("Class '" + string2 + "' configured for " + TYPE + " " + "(provider: " + serializable.getName() + ")" + " cannot be instantiated.", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new XMLEncryptionException("Class '" + string2 + "' configured for " + TYPE + " " + "(provider: " + serializable.getName() + ")" + " cannot be accessed.", illegalAccessException);
        }
        catch (SecurityException securityException) {
            throw new XMLEncryptionException("Class '" + string2 + "' configured for " + TYPE + " " + "(provider: " + serializable.getName() + ")" + " cannot be accessed.", securityException);
        }
    }

    protected XMLEncryptionFactory() {
    }
}

