/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.ElementValue;
import java.io.DataOutputStream;
import java.io.IOException;

public class EnumElementValue
extends ElementValue {
    private final int typeIdx;
    private final int valueIdx;

    public EnumElementValue(int type, int typeIdx, int valueIdx, ConstantPool cpool) {
        super(type, cpool);
        if (type != 101) {
            throw new RuntimeException("Only element values of type enum can be built with this ctor - type specified: " + type);
        }
        this.typeIdx = typeIdx;
        this.valueIdx = valueIdx;
    }

    @Override
    public void dump(DataOutputStream dos) throws IOException {
        dos.writeByte(super.getType());
        dos.writeShort(this.typeIdx);
        dos.writeShort(this.valueIdx);
    }

    @Override
    public String stringifyValue() {
        ConstantUtf8 cu8 = (ConstantUtf8)super.getConstantPool().getConstant(this.valueIdx, (byte)1);
        return cu8.getBytes();
    }

    public String getEnumTypeString() {
        ConstantUtf8 cu8 = (ConstantUtf8)super.getConstantPool().getConstant(this.typeIdx, (byte)1);
        return cu8.getBytes();
    }

    public String getEnumValueString() {
        ConstantUtf8 cu8 = (ConstantUtf8)super.getConstantPool().getConstant(this.valueIdx, (byte)1);
        return cu8.getBytes();
    }

    public int getValueIndex() {
        return this.valueIdx;
    }

    public int getTypeIndex() {
        return this.typeIdx;
    }
}

