/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.resource.internal;

import java.io.FileDescriptor;
import java.util.Objects;
import jdk.Exported;
import jdk.management.resource.ResourceAccuracy;
import jdk.management.resource.ResourceId;
import sun.misc.JavaIOFileDescriptorAccess;
import sun.misc.SharedSecrets;

@Exported(value=false)
public class ResourceIdImpl
implements ResourceId {
    private static final JavaIOFileDescriptorAccess FD_ACCESS = SharedSecrets.getJavaIOFileDescriptorAccess();
    private final Object target;
    private final ResourceAccuracy accuracy;
    private final boolean forceUpdate;

    public static ResourceIdImpl of(Object object) {
        return object == null ? null : new ResourceIdImpl(object, null, false);
    }

    public static ResourceIdImpl of(FileDescriptor fileDescriptor) {
        long l = -1L;
        if (fileDescriptor != null && (l = (long)FD_ACCESS.get(fileDescriptor)) == -1L) {
            try {
                l = FD_ACCESS.getHandle(fileDescriptor);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return l == -1L ? null : ResourceIdImpl.of((int)l);
    }

    public static ResourceIdImpl of(Object object, ResourceAccuracy resourceAccuracy) {
        return object == null ? null : new ResourceIdImpl(object, resourceAccuracy, false);
    }

    public static ResourceIdImpl of(Object object, ResourceAccuracy resourceAccuracy, boolean bl) {
        return object == null ? null : new ResourceIdImpl(object, resourceAccuracy, bl);
    }

    protected ResourceIdImpl(Object object, ResourceAccuracy resourceAccuracy, boolean bl) {
        this.target = object;
        this.accuracy = resourceAccuracy;
        this.forceUpdate = bl;
    }

    @Override
    public String getName() {
        return Objects.toString(this.target, null);
    }

    @Override
    public ResourceAccuracy getAccuracy() {
        return this.accuracy;
    }

    public boolean isForcedUpdate() {
        return this.forceUpdate;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getName());
        ResourceAccuracy resourceAccuracy = this.getAccuracy();
        if (resourceAccuracy != null) {
            stringBuilder.append(", accuracy: ");
            stringBuilder.append((Object)resourceAccuracy);
        }
        return stringBuilder.toString();
    }
}

