/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.resource.internal.inst;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.AsynchronousSocketChannel;
import jdk.internal.instrumentation.InstrumentationMethod;
import jdk.internal.instrumentation.InstrumentationTarget;
import jdk.management.resource.ResourceRequest;
import jdk.management.resource.ResourceRequestDeniedException;
import jdk.management.resource.internal.ApproverGroup;
import jdk.management.resource.internal.ResourceIdImpl;

@InstrumentationTarget(value="sun.nio.ch.AsynchronousSocketChannelImpl")
public class AsynchronousSocketChannelImplRMHooks {
    @InstrumentationMethod
    public final SocketAddress getLocalAddress() throws IOException {
        return this.getLocalAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public final AsynchronousSocketChannel bind(SocketAddress socketAddress) throws IOException {
        ResourceIdImpl resourceIdImpl = null;
        ResourceRequest resourceRequest = null;
        long l = 0L;
        if (this.getLocalAddress() == null) {
            resourceIdImpl = ResourceIdImpl.of(socketAddress);
            resourceRequest = ApproverGroup.SOCKET_OPEN_GROUP.getApprover(this);
            try {
                l = resourceRequest.request(1L, resourceIdImpl);
                if (l < 1L) {
                    throw new IOException("Resource limited: too many open socket channels");
                }
            }
            catch (ResourceRequestDeniedException resourceRequestDeniedException) {
                throw new IOException("Resource limited: too many open socket channels", resourceRequestDeniedException);
            }
        }
        int n = 0;
        AsynchronousSocketChannel asynchronousSocketChannel = null;
        try {
            asynchronousSocketChannel = this.bind(socketAddress);
            n = 1;
        }
        finally {
            if (resourceRequest != null) {
                resourceRequest.request(-(l - (long)n), resourceIdImpl);
            }
        }
        return asynchronousSocketChannel;
    }
}

