/*
 * Decompiled with CFR 0.152.
 */
package com.sun.beans.finder;

import com.sun.beans.TypeResolver;
import com.sun.beans.WeakCache;
import com.sun.beans.finder.AbstractFinder;
import com.sun.beans.finder.PrimitiveWrapperMap;
import com.sun.beans.finder.Signature;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;

public final class MethodFinder
extends AbstractFinder<Method> {
    private static final WeakCache<Signature, Method> CACHE = new WeakCache();
    private final String name;

    public static Method findMethod(Class<?> clazz, String string, Class<?> ... classArray) throws NoSuchMethodException {
        if (string == null) {
            throw new IllegalArgumentException("Method name is not set");
        }
        PrimitiveWrapperMap.replacePrimitivesWithWrappers(classArray);
        Signature signature = new Signature(clazz, string, classArray);
        Method method = CACHE.get(signature);
        if (method != null) {
            return method;
        }
        method = MethodFinder.findAccessibleMethod(new MethodFinder(string, classArray).find(clazz.getMethods()));
        CACHE.put(signature, method);
        return method;
    }

    public static Method findInstanceMethod(Class<?> clazz, String string, Class<?> ... classArray) throws NoSuchMethodException {
        Method method = MethodFinder.findMethod(clazz, string, classArray);
        if (Modifier.isStatic(method.getModifiers())) {
            throw new NoSuchMethodException("Method '" + string + "' is static");
        }
        return method;
    }

    public static Method findStaticMethod(Class<?> clazz, String string, Class<?> ... classArray) throws NoSuchMethodException {
        Method method = MethodFinder.findMethod(clazz, string, classArray);
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new NoSuchMethodException("Method '" + string + "' is not static");
        }
        return method;
    }

    public static Method findAccessibleMethod(Method method) throws NoSuchMethodException {
        Class<?> clazz = method.getDeclaringClass();
        if (Modifier.isPublic(clazz.getModifiers())) {
            return method;
        }
        if (Modifier.isStatic(method.getModifiers())) {
            throw new NoSuchMethodException("Method '" + method.getName() + "' is not accessible");
        }
        for (Type type : clazz.getGenericInterfaces()) {
            try {
                return MethodFinder.findAccessibleMethod(method, type);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return MethodFinder.findAccessibleMethod(method, clazz.getGenericSuperclass());
    }

    private static Method findAccessibleMethod(Method method, Type type) throws NoSuchMethodException {
        String string = method.getName();
        Object[] objectArray = method.getParameterTypes();
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return MethodFinder.findAccessibleMethod(clazz.getMethod(string, (Class<?>[])objectArray));
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class clazz = (Class)parameterizedType.getRawType();
            for (Method method2 : clazz.getMethods()) {
                Object[] objectArray2;
                if (!method2.getName().equals(string) || (objectArray2 = method2.getParameterTypes()).length != objectArray.length) continue;
                if (Arrays.equals(objectArray, objectArray2)) {
                    return MethodFinder.findAccessibleMethod(method2);
                }
                Type[] typeArray = method2.getGenericParameterTypes();
                if (!Arrays.equals(objectArray, TypeResolver.erase(TypeResolver.resolve((Type)parameterizedType, typeArray)))) continue;
                return MethodFinder.findAccessibleMethod(method2);
            }
        }
        throw new NoSuchMethodException("Method '" + string + "' is not accessible");
    }

    private MethodFinder(String string, Class<?>[] classArray) {
        super(classArray);
        this.name = string;
    }

    @Override
    protected Class<?>[] getParameters(Method method) {
        return method.getParameterTypes();
    }

    @Override
    protected boolean isVarArgs(Method method) {
        return method.isVarArgs();
    }

    @Override
    protected boolean isValid(Method method) {
        return Modifier.isPublic(method.getModifiers()) && method.getName().equals(this.name);
    }
}

