/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLabelUI;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthUI;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import sun.swing.plaf.synth.SynthIcon;

public class SynthTreeUI
extends BasicTreeUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;
    private SynthStyle cellStyle;
    private SynthContext paintContext;
    private boolean drawHorizontalLines;
    private boolean drawVerticalLines;
    private Object linesStyle;
    private int padding;
    private boolean useTreeColors;
    private Icon expandedIconWrapper = new ExpandedIconWrapper();

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthTreeUI();
    }

    @Override
    public Icon getExpandedIcon() {
        return this.expandedIconWrapper;
    }

    @Override
    protected void installDefaults() {
        this.updateStyle(this.tree);
    }

    private void updateStyle(JTree jTree) {
        SynthContext synthContext = this.getContext((JComponent)jTree, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            this.setExpandedIcon(this.style.getIcon(synthContext, "Tree.expandedIcon"));
            this.setCollapsedIcon(this.style.getIcon(synthContext, "Tree.collapsedIcon"));
            this.setLeftChildIndent(this.style.getInt(synthContext, "Tree.leftChildIndent", 0));
            this.setRightChildIndent(this.style.getInt(synthContext, "Tree.rightChildIndent", 0));
            this.drawHorizontalLines = this.style.getBoolean(synthContext, "Tree.drawHorizontalLines", true);
            this.drawVerticalLines = this.style.getBoolean(synthContext, "Tree.drawVerticalLines", true);
            this.linesStyle = this.style.get(synthContext, "Tree.linesStyle");
            Object object = this.style.get(synthContext, "Tree.rowHeight");
            if (object != null) {
                LookAndFeel.installProperty(jTree, "rowHeight", object);
            }
            LookAndFeel.installProperty(jTree, "scrollsOnExpand", (object = this.style.get(synthContext, "Tree.scrollsOnExpand")) != null ? object : Boolean.TRUE);
            this.padding = this.style.getInt(synthContext, "Tree.padding", 0);
            this.largeModel = jTree.isLargeModel() && jTree.getRowHeight() > 0;
            this.useTreeColors = this.style.getBoolean(synthContext, "Tree.rendererUseTreeColors", true);
            Boolean bl = this.style.getBoolean(synthContext, "Tree.showsRootHandles", Boolean.TRUE);
            LookAndFeel.installProperty(jTree, "showsRootHandles", bl);
            if (synthStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        synthContext.dispose();
        synthContext = this.getContext(jTree, Region.TREE_CELL, 1);
        this.cellStyle = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.tree.addPropertyChangeListener(this);
    }

    @Override
    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, SynthLookAndFeel.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n);
    }

    private SynthContext getContext(JComponent jComponent, Region region) {
        return this.getContext(jComponent, region, this.getComponentState(jComponent, region));
    }

    private SynthContext getContext(JComponent jComponent, Region region, int n) {
        return SynthContext.getContext(SynthContext.class, jComponent, region, this.cellStyle, n);
    }

    private int getComponentState(JComponent jComponent, Region region) {
        return 513;
    }

    @Override
    protected TreeCellEditor createDefaultCellEditor() {
        TreeCellRenderer treeCellRenderer = this.tree.getCellRenderer();
        SynthTreeCellEditor synthTreeCellEditor = treeCellRenderer != null && treeCellRenderer instanceof DefaultTreeCellRenderer ? new SynthTreeCellEditor(this.tree, (DefaultTreeCellRenderer)treeCellRenderer) : new SynthTreeCellEditor(this.tree, null);
        return synthTreeCellEditor;
    }

    @Override
    protected TreeCellRenderer createDefaultCellRenderer() {
        return new SynthTreeCellRenderer();
    }

    @Override
    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext((JComponent)this.tree, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
        synthContext = this.getContext(this.tree, Region.TREE_CELL, 1);
        this.cellStyle.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.cellStyle = null;
        if (this.tree.getTransferHandler() instanceof UIResource) {
            this.tree.setTransferHandler(null);
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.tree.removePropertyChangeListener(this);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintTreeBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    @Override
    public void paintBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        synthContext.getPainter().paintTreeBorder(synthContext, graphics, n, n2, n3, n4);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        this.paintContext = synthContext;
        this.updateLeadSelectionRow();
        Rectangle rectangle = graphics.getClipBounds();
        Insets insets = this.tree.getInsets();
        TreePath treePath = this.getClosestPathForLocation(this.tree, 0, rectangle.y);
        Enumeration<TreePath> enumeration = this.treeState.getVisiblePathsFrom(treePath);
        int n = this.treeState.getRowForPath(treePath);
        int n2 = rectangle.y + rectangle.height;
        TreeModel treeModel = this.tree.getModel();
        SynthContext synthContext2 = this.getContext((JComponent)this.tree, Region.TREE_CELL);
        this.drawingCache.clear();
        this.setHashColor(synthContext.getStyle().getColor(synthContext, ColorType.FOREGROUND));
        if (enumeration != null) {
            Rectangle rectangle2;
            boolean bl;
            boolean bl2;
            boolean bl3;
            TreePath treePath2;
            boolean bl4 = false;
            Rectangle rectangle3 = new Rectangle(0, 0, this.tree.getWidth(), 0);
            TreeCellRenderer treeCellRenderer = this.tree.getCellRenderer();
            DefaultTreeCellRenderer defaultTreeCellRenderer = treeCellRenderer instanceof DefaultTreeCellRenderer ? (DefaultTreeCellRenderer)treeCellRenderer : null;
            this.configureRenderer(synthContext2);
            while (!bl4 && enumeration.hasMoreElements()) {
                treePath2 = enumeration.nextElement();
                if (treePath2 != null) {
                    bl3 = treeModel.isLeaf(treePath2.getLastPathComponent());
                    if (bl3) {
                        bl2 = false;
                        bl = false;
                    } else {
                        bl = this.treeState.getExpandedState(treePath2);
                        bl2 = this.tree.hasBeenExpanded(treePath2);
                    }
                    rectangle2 = this.getPathBounds(this.tree, treePath2);
                    rectangle3.y = rectangle2.y;
                    rectangle3.height = rectangle2.height;
                    this.paintRow(treeCellRenderer, defaultTreeCellRenderer, synthContext, synthContext2, graphics, rectangle, insets, rectangle2, rectangle3, treePath2, n, bl, bl2, bl3);
                    if (rectangle2.y + rectangle2.height >= n2) {
                        bl4 = true;
                    }
                } else {
                    bl4 = true;
                }
                ++n;
            }
            boolean bl5 = this.tree.isRootVisible();
            TreePath treePath3 = treePath;
            for (treePath3 = treePath3.getParentPath(); treePath3 != null; treePath3 = treePath3.getParentPath()) {
                this.paintVerticalPartOfLeg(graphics, rectangle, insets, treePath3);
                this.drawingCache.put(treePath3, Boolean.TRUE);
            }
            bl4 = false;
            enumeration = this.treeState.getVisiblePathsFrom(treePath);
            while (!bl4 && enumeration.hasMoreElements()) {
                treePath2 = enumeration.nextElement();
                if (treePath2 != null) {
                    bl3 = treeModel.isLeaf(treePath2.getLastPathComponent());
                    if (bl3) {
                        bl2 = false;
                        bl = false;
                    } else {
                        bl = this.treeState.getExpandedState(treePath2);
                        bl2 = this.tree.hasBeenExpanded(treePath2);
                    }
                    rectangle2 = this.getPathBounds(this.tree, treePath2);
                    treePath3 = treePath2.getParentPath();
                    if (treePath3 != null) {
                        if (this.drawingCache.get(treePath3) == null) {
                            this.paintVerticalPartOfLeg(graphics, rectangle, insets, treePath3);
                            this.drawingCache.put(treePath3, Boolean.TRUE);
                        }
                        this.paintHorizontalPartOfLeg(graphics, rectangle, insets, rectangle2, treePath2, n, bl, bl2, bl3);
                    } else if (bl5 && n == 0) {
                        this.paintHorizontalPartOfLeg(graphics, rectangle, insets, rectangle2, treePath2, n, bl, bl2, bl3);
                    }
                    if (this.shouldPaintExpandControl(treePath2, n, bl, bl2, bl3)) {
                        this.paintExpandControl(graphics, rectangle, insets, rectangle2, treePath2, n, bl, bl2, bl3);
                    }
                    if (rectangle2.y + rectangle2.height >= n2) {
                        bl4 = true;
                    }
                } else {
                    bl4 = true;
                }
                ++n;
            }
        }
        synthContext2.dispose();
        this.paintDropLine(graphics);
        this.rendererPane.removeAll();
    }

    private void configureRenderer(SynthContext synthContext) {
        TreeCellRenderer treeCellRenderer = this.tree.getCellRenderer();
        if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
            DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
            SynthStyle synthStyle = synthContext.getStyle();
            synthContext.setComponentState(513);
            Color color = defaultTreeCellRenderer.getTextSelectionColor();
            if (color == null || color instanceof UIResource) {
                defaultTreeCellRenderer.setTextSelectionColor(synthStyle.getColor(synthContext, ColorType.TEXT_FOREGROUND));
            }
            if ((color = defaultTreeCellRenderer.getBackgroundSelectionColor()) == null || color instanceof UIResource) {
                defaultTreeCellRenderer.setBackgroundSelectionColor(synthStyle.getColor(synthContext, ColorType.TEXT_BACKGROUND));
            }
            synthContext.setComponentState(1);
            color = defaultTreeCellRenderer.getTextNonSelectionColor();
            if (color == null || color instanceof UIResource) {
                defaultTreeCellRenderer.setTextNonSelectionColor(synthStyle.getColorForState(synthContext, ColorType.TEXT_FOREGROUND));
            }
            if ((color = defaultTreeCellRenderer.getBackgroundNonSelectionColor()) == null || color instanceof UIResource) {
                defaultTreeCellRenderer.setBackgroundNonSelectionColor(synthStyle.getColorForState(synthContext, ColorType.TEXT_BACKGROUND));
            }
        }
    }

    @Override
    protected void paintHorizontalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        if (this.drawHorizontalLines) {
            super.paintHorizontalPartOfLeg(graphics, rectangle, insets, rectangle2, treePath, n, bl, bl2, bl3);
        }
    }

    @Override
    protected void paintHorizontalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
        this.paintContext.getStyle().getGraphicsUtils(this.paintContext).drawLine(this.paintContext, "Tree.horizontalLine", graphics, n2, n, n3, n, this.linesStyle);
    }

    @Override
    protected void paintVerticalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, TreePath treePath) {
        if (this.drawVerticalLines) {
            super.paintVerticalPartOfLeg(graphics, rectangle, insets, treePath);
        }
    }

    @Override
    protected void paintVerticalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
        this.paintContext.getStyle().getGraphicsUtils(this.paintContext).drawLine(this.paintContext, "Tree.verticalLine", graphics, n, n2, n, n3, this.linesStyle);
    }

    private void paintRow(TreeCellRenderer treeCellRenderer, DefaultTreeCellRenderer defaultTreeCellRenderer, SynthContext synthContext, SynthContext synthContext2, Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, Rectangle rectangle3, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = this.tree.isRowSelected(n);
        JTree.DropLocation dropLocation = this.tree.getDropLocation();
        boolean bl5 = dropLocation != null && dropLocation.getChildIndex() == -1 && treePath == dropLocation.getPath();
        int n2 = 1;
        if (bl4 || bl5) {
            n2 |= 0x200;
        }
        if (this.tree.isFocusOwner() && n == this.getLeadSelectionRow()) {
            n2 |= 0x100;
        }
        synthContext2.setComponentState(n2);
        if (defaultTreeCellRenderer != null && defaultTreeCellRenderer.getBorderSelectionColor() instanceof UIResource) {
            defaultTreeCellRenderer.setBorderSelectionColor(this.style.getColor(synthContext2, ColorType.FOCUS));
        }
        SynthLookAndFeel.updateSubregion(synthContext2, graphics, rectangle3);
        synthContext2.getPainter().paintTreeCellBackground(synthContext2, graphics, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        synthContext2.getPainter().paintTreeCellBorder(synthContext2, graphics, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        if (this.editingComponent != null && this.editingRow == n) {
            return;
        }
        int n3 = this.tree.hasFocus() ? this.getLeadSelectionRow() : -1;
        Component component = treeCellRenderer.getTreeCellRendererComponent(this.tree, treePath.getLastPathComponent(), bl4, bl, bl3, n, n3 == n);
        this.rendererPane.paintComponent(graphics, component, this.tree, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, true);
    }

    private int findCenteredX(int n, int n2) {
        return this.tree.getComponentOrientation().isLeftToRight() ? n - (int)Math.ceil((double)n2 / 2.0) : n - (int)Math.floor((double)n2 / 2.0);
    }

    @Override
    protected void paintExpandControl(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = this.tree.getSelectionModel().isPathSelected(treePath);
        int n2 = this.paintContext.getComponentState();
        if (bl4) {
            this.paintContext.setComponentState(n2 | 0x200);
        }
        super.paintExpandControl(graphics, rectangle, insets, rectangle2, treePath, n, bl, bl2, bl3);
        this.paintContext.setComponentState(n2);
    }

    @Override
    protected void drawCentered(Component component, Graphics graphics, Icon icon, int n, int n2) {
        int n3 = SynthIcon.getIconWidth(icon, this.paintContext);
        int n4 = SynthIcon.getIconHeight(icon, this.paintContext);
        SynthIcon.paintIcon(icon, this.paintContext, graphics, this.findCenteredX(n, n3), n2 - n4 / 2, n3, n4);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle((JTree)propertyChangeEvent.getSource());
        }
        if ("dropLocation" == propertyChangeEvent.getPropertyName()) {
            JTree.DropLocation dropLocation = (JTree.DropLocation)propertyChangeEvent.getOldValue();
            this.repaintDropLocation(dropLocation);
            this.repaintDropLocation(this.tree.getDropLocation());
        }
    }

    @Override
    protected void paintDropLine(Graphics graphics) {
        JTree.DropLocation dropLocation = this.tree.getDropLocation();
        if (!this.isDropLine(dropLocation)) {
            return;
        }
        Color color = (Color)this.style.get(this.paintContext, "Tree.dropLineColor");
        if (color != null) {
            graphics.setColor(color);
            Rectangle rectangle = this.getDropLineRect(dropLocation);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private void repaintDropLocation(JTree.DropLocation dropLocation) {
        Rectangle rectangle;
        if (dropLocation == null) {
            return;
        }
        if (this.isDropLine(dropLocation)) {
            rectangle = this.getDropLineRect(dropLocation);
        } else {
            rectangle = this.tree.getPathBounds(dropLocation.getPath());
            if (rectangle != null) {
                rectangle.x = 0;
                rectangle.width = this.tree.getWidth();
            }
        }
        if (rectangle != null) {
            this.tree.repaint(rectangle);
        }
    }

    @Override
    protected int getRowX(int n, int n2) {
        return super.getRowX(n, n2) + this.padding;
    }

    private class ExpandedIconWrapper
    extends SynthIcon {
        private ExpandedIconWrapper() {
        }

        @Override
        public void paintIcon(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            if (synthContext == null) {
                synthContext = SynthTreeUI.this.getContext(SynthTreeUI.this.tree);
                SynthIcon.paintIcon(SynthTreeUI.this.expandedIcon, synthContext, graphics, n, n2, n3, n4);
                synthContext.dispose();
            } else {
                SynthIcon.paintIcon(SynthTreeUI.this.expandedIcon, synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public int getIconWidth(SynthContext synthContext) {
            int n;
            if (synthContext == null) {
                synthContext = SynthTreeUI.this.getContext(SynthTreeUI.this.tree);
                n = SynthIcon.getIconWidth(SynthTreeUI.this.expandedIcon, synthContext);
                synthContext.dispose();
            } else {
                n = SynthIcon.getIconWidth(SynthTreeUI.this.expandedIcon, synthContext);
            }
            return n;
        }

        @Override
        public int getIconHeight(SynthContext synthContext) {
            int n;
            if (synthContext == null) {
                synthContext = SynthTreeUI.this.getContext(SynthTreeUI.this.tree);
                n = SynthIcon.getIconHeight(SynthTreeUI.this.expandedIcon, synthContext);
                synthContext.dispose();
            } else {
                n = SynthIcon.getIconHeight(SynthTreeUI.this.expandedIcon, synthContext);
            }
            return n;
        }
    }

    private static class SynthTreeCellEditor
    extends DefaultTreeCellEditor {
        public SynthTreeCellEditor(JTree jTree, DefaultTreeCellRenderer defaultTreeCellRenderer) {
            super(jTree, defaultTreeCellRenderer);
            this.setBorderSelectionColor(null);
        }

        @Override
        protected TreeCellEditor createTreeCellEditor() {
            JTextField jTextField = new JTextField(){

                @Override
                public String getName() {
                    return "Tree.cellEditor";
                }
            };
            DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jTextField);
            defaultCellEditor.setClickCountToStart(1);
            return defaultCellEditor;
        }
    }

    private class SynthTreeCellRenderer
    extends DefaultTreeCellRenderer
    implements UIResource {
        SynthTreeCellRenderer() {
        }

        @Override
        public String getName() {
            return "Tree.cellRenderer";
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            if (!SynthTreeUI.this.useTreeColors && (bl || bl4)) {
                SynthLookAndFeel.setSelectedUI((SynthLabelUI)SynthLookAndFeel.getUIOfType(this.getUI(), SynthLabelUI.class), bl, bl4, jTree.isEnabled(), false);
            } else {
                SynthLookAndFeel.resetSelectedUI();
            }
            return super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        }

        @Override
        public void paint(Graphics graphics) {
            this.paintComponent(graphics);
            if (this.hasFocus) {
                SynthContext synthContext = SynthTreeUI.this.getContext(SynthTreeUI.this.tree, Region.TREE_CELL);
                if (synthContext.getStyle() == null) {
                    assert (false) : "SynthTreeCellRenderer is being used outside of UI that created it";
                    return;
                }
                int n = 0;
                Icon icon = this.getIcon();
                if (icon != null && this.getText() != null) {
                    n = icon.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
                }
                if (this.selected) {
                    synthContext.setComponentState(513);
                } else {
                    synthContext.setComponentState(1);
                }
                if (this.getComponentOrientation().isLeftToRight()) {
                    synthContext.getPainter().paintTreeCellFocus(synthContext, graphics, n, 0, this.getWidth() - n, this.getHeight());
                } else {
                    synthContext.getPainter().paintTreeCellFocus(synthContext, graphics, 0, 0, this.getWidth() - n, this.getHeight());
                }
                synthContext.dispose();
            }
            SynthLookAndFeel.resetSelectedUI();
        }
    }
}

