/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.kerberos.KeyTab;
import sun.security.jgss.krb5.Krb5Util;

class SubjectComber {
    private static final boolean DEBUG = Krb5Util.DEBUG;

    private SubjectComber() {
    }

    static <T> T find(Subject subject, String string, String string2, Class<T> clazz) {
        return (T)SubjectComber.findAux(subject, string, string2, clazz, true);
    }

    static <T> List<T> findMany(Subject subject, String string, String string2, Class<T> clazz) {
        return (List)SubjectComber.findAux(subject, string, string2, clazz, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> Object findAux(Subject subject, String string, String string2, Class<T> clazz, boolean bl) {
        ArrayList<Object> arrayList;
        if (subject == null) {
            return null;
        }
        ArrayList<Object> arrayList2 = arrayList = bl ? null : new ArrayList<Object>();
        if (clazz == KeyTab.class) {
            for (T t : subject.getPrivateCredentials(clazz)) {
                if (DEBUG) {
                    System.out.println("Found " + clazz.getSimpleName());
                }
                if (bl) {
                    return t;
                }
                arrayList.add(t);
            }
        } else if (clazz == KerberosKey.class) {
            for (T t : subject.getPrivateCredentials(clazz)) {
                String string3 = ((KerberosKey)t).getPrincipal().getName();
                if (string != null && !string.equals(string3)) continue;
                if (DEBUG) {
                    System.out.println("Found " + clazz.getSimpleName() + " for " + string3);
                }
                if (bl) {
                    return t;
                }
                if (string == null) {
                    string = string3;
                }
                arrayList.add(t);
            }
        } else if (clazz == KerberosTicket.class) {
            Set<Object> set;
            Set<Object> set2 = set = subject.getPrivateCredentials();
            synchronized (set2) {
                Iterator<Object> iterator = set.iterator();
                while (iterator.hasNext()) {
                    Object object = iterator.next();
                    if (!(object instanceof KerberosTicket)) continue;
                    KerberosTicket kerberosTicket = (KerberosTicket)object;
                    if (DEBUG) {
                        System.out.println("Found ticket for " + kerberosTicket.getClient() + " to go to " + kerberosTicket.getServer() + " expiring on " + kerberosTicket.getEndTime());
                    }
                    if (!kerberosTicket.isCurrent()) {
                        if (subject.isReadOnly()) continue;
                        iterator.remove();
                        try {
                            kerberosTicket.destroy();
                            if (!DEBUG) continue;
                            System.out.println("Removed and destroyed the expired Ticket \n" + kerberosTicket);
                        }
                        catch (DestroyFailedException destroyFailedException) {
                            if (!DEBUG) continue;
                            System.out.println("Expired ticket not detroyed successfully. " + destroyFailedException);
                        }
                        continue;
                    }
                    if (string != null && !kerberosTicket.getServer().getName().equals(string) || string2 != null && !string2.equals(kerberosTicket.getClient().getName())) continue;
                    if (bl) {
                        return kerberosTicket;
                    }
                    if (string2 == null) {
                        string2 = kerberosTicket.getClient().getName();
                    }
                    if (string == null) {
                        string = kerberosTicket.getServer().getName();
                    }
                    arrayList.add(kerberosTicket);
                }
            }
        }
        return arrayList;
    }
}

